#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/delay.h>
#include <linux/dvb/frontend.h>

#include "dvb_frontend.h"
#include "FS803A.h"
#include "af901x.h"

#define IF2  36150       // IF2 frequency = 36.150 MHz
#define FREF 16000       // Quartz oscillator 16 MHz

static int fs803_set_params(struct dvb_frontend *fe, struct dvb_frontend_parameters *params)
{
	struct fs803_priv *priv=NULL;
	u32 freq = params->frequency / 1000; // Hz -> kHz
	priv->bandwidth = (fe->ops.info.type == FE_OFDM) ? params->u.ofdm.bandwidth : 0;

    printk("%s\n",__FUNCTION__);
	printk("%d   %d\n",freq,priv->bandwidth);
	FS803_Set(freq,priv->bandwidth);
	return 0;
}

static void fs803_calibrate(struct fs803_priv *priv)
{
}

static int fs803_get_frequency(struct dvb_frontend *fe, u32 *frequency)
{
	struct fs803_priv *priv = fe->tuner_priv;
	*frequency = priv->frequency;
	return 0;
}

static int fs803_get_bandwidth(struct dvb_frontend *fe, u32 *bandwidth)
{
	struct fs803_priv *priv = fe->tuner_priv;
	*bandwidth = priv->bandwidth;
	return 0;
}

static int fs803_init(struct dvb_frontend *fe)
{
	return 0;
}

static int fs803_sleep(struct dvb_frontend *fe)
{
	return 0;
}

static int fs803_release(struct dvb_frontend *fe)
{
	kfree(fe->tuner_priv);
	fe->tuner_priv = NULL;
	return 0;
}

static const struct dvb_tuner_ops fs803_tuner_ops = {
	.info = {
		.name           = "Freescale FS803",
		.frequency_min  =  48000000,
		.frequency_max  = 860000000,
		.frequency_step =     50000,
	},

	.release       = fs803_release,

	.init          = fs803_init,
	.sleep         = fs803_sleep,

	.set_params    = fs803_set_params,
	.get_frequency = fs803_get_frequency,
	.get_bandwidth = fs803_get_bandwidth
};

/* This functions tries to identify a FS803a tuner by reading the PART/REV register. This is hasty. */
struct dvb_frontend * fs803_attach(struct dvb_frontend *fe)
{
	struct fs803_priv *priv = NULL;

	priv = kzalloc(sizeof(struct fs803_priv), GFP_KERNEL);
	if (priv == NULL)
		return NULL;

	//printk(KERN_INFO "MT2060: successfully identified\n");
	memcpy(&fe->ops.tuner_ops, &fs803_tuner_ops, sizeof(struct dvb_tuner_ops));

	fe->tuner_priv = priv;
	
	return fe;
}
EXPORT_SYMBOL(fs803_attach);
